/*
 * Decompiled with CFR 0.152.
 */
package meldexun.entityculling.plugin;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.Random;
import meldexun.entityculling.EntityCullingClient;
import meldexun.entityculling.EntityCullingConfig;
import meldexun.entityculling.ICullable;
import meldexun.entityculling.reflection.ReflectionField;
import meldexun.entityculling.reflection.ReflectionMethod;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector4f;

public class Hook {
    private static final ReflectionField<Integer> FIELD_COUNT_ENTITIES_RENDERED = new ReflectionField(WorldRenderer.class, "field_72749_I", "renderedEntities");
    private static final ReflectionField<Integer> FIELD_DEBUG_FPS = new ReflectionField(Minecraft.class, "field_71470_ab", "fps");
    private static final ReflectionMethod<Boolean> METHOD_IS_BOX_IN_FRUSTUM = new ReflectionMethod(ClippingHelper.class, "func_228953_a_", "cubeInFrustum", Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE);
    private static final ReflectionField<ChunkRenderDispatcher.ChunkRender> FIELD_RENDER_CHUNK = new ReflectionField("net.minecraft.client.renderer.WorldRenderer$LocalRenderInformationContainer", "field_178036_a", "chunk");
    private static final ByteBuffer COLOR_MASK_BUFFER = ByteBuffer.allocateDirect(4).order(ByteOrder.nativeOrder());
    private static final FloatBuffer MATRIX_BUFFER = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asFloatBuffer();
    private static final Random RAND = new Random();
    public static int entitiesRendered;
    public static int entitiesOcclusionCulled;
    public static int tileEntitiesRendered;
    public static int tileEntitiesOcclusionCulled;
    private static double x;
    private static double y;
    private static double z;

    private Hook() {
    }

    public static boolean shouldRenderEntity(Entity entity) {
        if (((ICullable)entity).isVisible()) {
            ++entitiesRendered;
            return true;
        }
        ++entitiesOcclusionCulled;
        return false;
    }

    public static boolean shouldRenderTileEntity(TileEntity tileEntity) {
        if (((ICullable)tileEntity).isVisible()) {
            ++tileEntitiesRendered;
            return true;
        }
        ++tileEntitiesOcclusionCulled;
        return false;
    }

    public static void preRenderEntities(ActiveRenderInfo activeRenderInfoIn, MatrixStack matrixStackIn, Matrix4f projectionIn) {
        entitiesRendered = 0;
        entitiesOcclusionCulled = 0;
        tileEntitiesRendered = 0;
        tileEntitiesOcclusionCulled = 0;
        Minecraft mc = Minecraft.func_71410_x();
        Vector3d vec = activeRenderInfoIn.func_216785_c();
        x = vec.field_72450_a;
        y = vec.field_72448_b;
        z = vec.field_72449_c;
        ClippingHelper frustum = new ClippingHelper(matrixStackIn.func_227866_c_().func_227870_a_(), projectionIn);
        frustum.func_228952_a_(x, y, z);
        EntityCullingClient.CULLING_THREAD.camX = x;
        EntityCullingClient.CULLING_THREAD.camY = y;
        EntityCullingClient.CULLING_THREAD.camZ = z;
        EntityCullingClient.CULLING_THREAD.matrix = matrixStackIn.func_227866_c_().func_227870_a_().func_226601_d_();
        EntityCullingClient.CULLING_THREAD.projection = projectionIn.func_226601_d_();
    }

    public static void postRenderEntities() {
        Minecraft mc = Minecraft.func_71410_x();
        FIELD_COUNT_ENTITIES_RENDERED.set(mc.field_71438_f, FIELD_COUNT_ENTITIES_RENDERED.get(mc.field_71438_f) - entitiesOcclusionCulled);
    }

    public static boolean shouldRenderEntityShadow(Entity entity) {
        if (((ICullable)entity).isCulledShadowPass()) {
            return false;
        }
        if (!((Boolean)EntityCullingConfig.CLIENT_CONFIG.optifineShaderOptions.entityShadowsDistanceLimited.get()).booleanValue()) {
            return true;
        }
        double d = (Double)EntityCullingConfig.CLIENT_CONFIG.optifineShaderOptions.entityShadowsMaxDistance.get() * 16.0;
        return entity.func_70092_e(x, y, z) < d * d;
    }

    public static boolean shouldRenderTileEntityShadow(TileEntity tileEntity) {
        if (((ICullable)tileEntity).isCulledShadowPass()) {
            return false;
        }
        if (!((Boolean)EntityCullingConfig.CLIENT_CONFIG.optifineShaderOptions.tileEntityShadowsDistanceLimited.get()).booleanValue()) {
            return true;
        }
        double d = (Double)EntityCullingConfig.CLIENT_CONFIG.optifineShaderOptions.tileEntityShadowsMaxDistance.get() * 16.0;
        return Hook.squareDist((double)tileEntity.func_174877_v().func_177958_n() + 0.5, (double)tileEntity.func_174877_v().func_177956_o() + 0.5, (double)tileEntity.func_174877_v().func_177952_p() + 0.5, x, y, z) < d * d;
    }

    private static double squareDist(double x1, double y1, double z1, double x2, double y2, double z2) {
        return (x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1) + (z2 - z1) * (z2 - z1);
    }

    public static boolean shouldRenderChunkShadow(Object containerLocalRenderInformation) {
        if (!((Boolean)EntityCullingConfig.CLIENT_CONFIG.enabled.get()).booleanValue()) {
            return true;
        }
        if (!((Boolean)EntityCullingConfig.CLIENT_CONFIG.optifineShaderOptions.terrainShadowsEnabled.get()).booleanValue()) {
            return false;
        }
        if (!((Boolean)EntityCullingConfig.CLIENT_CONFIG.optifineShaderOptions.terrainShadowsDistanceLimited.get()).booleanValue()) {
            return true;
        }
        ChunkRenderDispatcher.ChunkRender renderChunk = FIELD_RENDER_CHUNK.get(containerLocalRenderInformation);
        BlockPos pos = renderChunk.func_178568_j();
        if (Math.abs((double)pos.func_177958_n() + 8.0 - x) > (Double)EntityCullingConfig.CLIENT_CONFIG.optifineShaderOptions.terrainShadowsMaxHorizontalDistance.get() * 16.0) {
            return false;
        }
        if (Math.abs((double)pos.func_177956_o() + 8.0 - y) > (Double)EntityCullingConfig.CLIENT_CONFIG.optifineShaderOptions.terrainShadowsMaxVerticalDistance.get() * 16.0) {
            return false;
        }
        return Math.abs((double)pos.func_177952_p() + 8.0 - z) <= (Double)EntityCullingConfig.CLIENT_CONFIG.optifineShaderOptions.terrainShadowsMaxHorizontalDistance.get() * 16.0;
    }

    public static boolean cubeInFrustum(Vector4f[] frustumData, float x0, float y0, float z0, float x1, float y1, float z1) {
        for (int i = 0; i < frustumData.length; ++i) {
            Vector4f v = frustumData[i];
            float f = v.func_195910_a();
            float f2 = v.func_195913_b();
            float f3 = v.func_195914_c();
            float f4 = v.func_195915_d();
            float f5 = v.func_195910_a() >= 0.0f ? x1 : x0;
            float f6 = v.func_195913_b() >= 0.0f ? y1 : y0;
            float f7 = v.func_195914_c() >= 0.0f ? z1 : z0;
            if (!(Hook.dist(f, f2, f3, f4, f5, f6, f7) <= 0.0f)) continue;
            return false;
        }
        return true;
    }

    private static float dist(float planeX, float planeY, float planeZ, float planeW, float x, float y, float z) {
        return planeX * x + planeY * y + planeZ * z + planeW;
    }
}

